clear
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/International Data September 2016/Data/risk_assets.dta"
merge m:m date name using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/International Data September 2016/Data/price.dta"
drop _merge
merge m:m date name using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/International Data September 2016/Data/shrout.dta"
drop _merge
merge m:m date name using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/International Data September 2016/Data/assets.dta"
drop _merge 
merge m:m date name using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/International Data September 2016/Data/tangible.dta"

drop if year <= 1997 | year == . 

gen length_name = length(name)
drop if length == 0 


by name, sort: gen output_indicator = _n 
replace output_indicator = 0 if output_indicator != 1 
br if output_indicator == 1

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/International Data September 2016/Data/fullvars_stack.dta", replace


use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/International Data September 2016/Data/fullvars_stack.dta", clear
rename name bank 

gen country = " " 

replace country = "uk" if bank == "hsbc" | bank == "barclays" | bank == "lloyds" | bank == "rbs" | bank == "standchart" 

replace country = "france" if bank == "bnp" | bank == "agricole" | bank == "societe" | bank == "natixis" 

replace country = "japan" if bank == "mitsu" | bank == "mizuho" | bank == "sumitomo" 

replace country = "germany" if bank == "deusche" | bank == "commerz" | bank == "kfw"

replace country = "spain" if bank == "santander" 

replace country = "switzerland" if bank == "ubs" | bank == "creditsui" 

replace country = "italy" if bank == "unicredit" | bank == "intesa" 

replace country = "netherlands" if bank == "ing" | bank == "rabbob" 

replace country = "canada" if bank == "toronto" | bank == "rbc" | bank == "novascotia" | bank == "bankmontreal" 

replace country = "australia" if bank == "ausnzbank" | bank == "natlaust" | bank == "westpac" 

replace country = "brazil" if bank == "bancobrazil"

replace country = "sweden" if bank == "nordea" 

replace country = "denmark" if bank == "danske"

br if country == " " 

drop if country == " "

**** now we want country averages, pre, post, 2015 for (1) mve/assets; (2) mve/risk assets 
generate crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year <= 2015
replace crisis = . if year == 2002 & bank == "nordea" 

gen mve = shrout*price 

gen mve_div_assets = mve/assets

gen mve_div_risk=mve/risk_assets

by country crisis, sort: egen mve_div_assets_crisis = mean(mve_div_assets)
by country crisis, sort: egen mve_div_risk_crisis = mean(mve_div_risk)
by country crisis, sort: egen tangible_crisis = mean(tangible)

drop output_indicator 

by crisis country, sort: gen output_indicator = _n 

br crisis country mve_div_assets_crisis mve_div_risk_crisis tangible_crisis if output_indicator == 1 & crisis != . 

**** annual averages 
drop output_indicator 

by country year, sort: egen mve_div_assets_annual = mean(mve_div_assets)
by country year, sort: egen mve_div_risk_annual = mean(mve_div_risk)
by country year, sort: egen tangible_annual = mean(tangible)

by year country, sort: gen output_indicator = _n 
br crisis year country mve_div_assets_annual mve_div_risk_annual tangible_annual if (year == 2015 & output_indicator == 1)

gen day = day(date)
gen month = month(date) 
keep if day == 31 & year == 2015 & month == 12

by country, sort: egen mve_div_assets_recent = mean(mve_div_assets)
by country, sort: egen mve_div_risk_recent = mean(mve_div_risk)

drop output_indicator 
by country, sort: gen output_indicator = _n 
br crisis year country mve_div_assets_recent mve_div_risk_recent tangible_annual if output_indicator == 1 



